/*********************************************************************************************************//**
 * @file    BC3603Test.h
 * @version $Rev:: 5827         $
 * @date    $Date:: 2022-09-29 #$
 * @brief   The header file of the RF test.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __RF_TEST_H
#define __RF_TEST_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------*/
#include "ht32.h"

/** @addtogroup HT32F67232_Peripheral_Driver HT32F67232 Peripheral Driver
  * @{
  */

/** @addtogroup RF
  * @{
  */
  
/***********************************************************************************************
RF Test Interface Caption:
	1. MCU		RF
		PA14---->HIGH	: SPI Chip select pin
		PA15<----GIO4	: Direct mode TBCLK or RBCLK
		PA9<-----GIO1	: Direct mode RXD
		PB12---->GIO1	: Direct mode TXD
************************************************************************************************/  
/* Exported constants --------------------------------------------------------------------------*/
/** @defgroup RF_Exported_Constants RF exported constants
  * @{
  */

  
/**
  * @}
  */
  
  
/* Exported types ------------------------------------------------------------------------------------------*/
/** @defgroup RF_Exported_Types RF exported types
  * @{
  */

/**
  *  @brief Enumeration of direct mode selection
  */
typedef enum
{
	CARRIER = 0,							/* carrier mode */
	DIRECT_TX,      						/* direct Tx mode */
	DIRECT_RX                        /* direct Rx mode */
}	RF_DIRM_Enum;

/**
  * @}
  */

extern uc8	PN9Patten[];
#define	PN9PattenSize					511

/* Exported functions --------------------------------------------------------------------------------------*/
/** @defgroup RF_Exported_Functions RF exported functions
  * @{
  */  
void 	BC3603_DirectModeActive(RF_DIRM_Enum DirMode);
void 	BC3603_DirectModeInactive(void);
void 	BC3603_DirectTransmit(u32 DataRate,u8 *SAddr,u16 SPos,u16 Size);
void 	BC3603_DirectTxTermination(void);
void 	BC3603_DirectReceiver(u32 DataRate,u8 *SAddr,u16 Size);
bool 	BC3603_GetDirectReceiverData(u8 *Data);
void 	BC3603_DirectRxTermination(void);

/**
  * @}
  */


/**
  * @}
  */

/**
  * @}
  */

#ifdef __cplusplus
}
#endif

#endif


/* Exported constants --------------------------------------------------------------------------*/
/** @defgroup RF_Exported_Constants RF exported constants
  * @{
  */
